#pragma once

#include "iterator.h"

#include <util/generic/array_ref.h>
#include <util/generic/vector.h>
#include <util/generic/deque.h>

namespace NSolomon::NTsModel {

/**
 * Concatenate multiple iterators.
 */
template <typename TIt>
class TCatIterator final: public IIterator<typename TIt::TPoint> {
    static_assert(IsIteratorV<TIt>, "expected an iterator");

public:
    TCatIterator() = default;

    TCatIterator(TDeque<TIt> iterators)
        : Iterators(std::move(iterators))
    {
    }

public:
    /**
     * Add new iterator to the concatenation.
     */
    void Append(TIt it) {
        Iterators.push_back(std::move(it));
    }

public:
    bool NextPoint(typename TIt::TPoint* point) override {
        while (!Iterators.empty() && !Iterators.front().NextPoint(point)) {
            Iterators.pop_front();
        }

        return !Iterators.empty();
    }

public:
    TDeque<TIt> Iterators;
};

} // namespace NSolomon::NTsModel
