#pragma once

#include "iterator.h"

namespace NSolomon::NTsModel {

/**
 * Crop time series.
 */
template <typename TIt>
class TCropIterator final: public IIterator<typename TIt::TPoint> {
    static_assert(IsIteratorV<TIt>, "expected an iterator");

public:
    explicit TCropIterator(TIt underlying, TInstant minTs, TInstant maxTs)
        : Underlying_(std::move(underlying))
        , MinTs_{minTs}
        , MaxTs_{maxTs}
    {
        LoadPoint();
    }

public:
    bool NextPoint(typename TIt::TPoint* point) override {
        if (!HasPoint_) {
            return false;
        }

        std::swap(*point, Cur_);
        LoadPoint();
        return true;
    }

private:
    void LoadPoint() {
        HasPoint_ = false;
        while (Underlying_.NextPoint(&Cur_)) {
            if (Cur_.Time < MinTs_) {
                continue;
            }
            if (Cur_.Time >= MaxTs_) {
                break;
            }

            HasPoint_ = true;
            break;
        }
    }

private:
    TIt Underlying_;
    TInstant MinTs_;
    TInstant MaxTs_;
    typename TIt::TPoint Cur_;
    bool HasPoint_ = false;
};

} // namespace NSolomon::NTsModel
