#pragma once

#include "iterator.h"
#include "point_traits.h"

namespace NSolomon::NTsModel {

/**
 * An iterator that reads an encoded data.
 */
template <typename TPoint>
class TDecodeIterator: public IIterator<TPoint> {
public:
    using TDecoder = TDecoder<TPoint>;

public:
    explicit TDecodeIterator(TDecoder decoder)
        : Decoder_(std::move(decoder))
    {
    }

    /**
     * Create a reader for simple (non-aggregated) points.
     */
    static TDecodeIterator<TPoint> Simple(NTs::TBitSpan data) {
        return TDecodeIterator<TPoint>{TDecoder::Simple(data)};
    }

    /**
     * Create a reader for aggregated points.
     */
    static TDecodeIterator<TPoint> Aggr(NTs::TBitSpan data) {
        return TDecodeIterator<TPoint>{TDecoder::Aggr(data)};
    }

public:
    bool NextPoint(TPoint* point) override {
        return Decoder_.NextPoint(point);
    }

private:
    TDecoder Decoder_;
};

} // namespace NSolomon::NTsModel
