#pragma once

#include "iterator.h"

#include <util/generic/array_ref.h>
#include <util/generic/vector.h>
#include <util/generic/deque.h>

namespace NSolomon::NTsModel {

/**
 * Iterate over points from a container.
 */
template <typename TPoint, typename TContainer = TVector<TPoint>>
class TListIterator final: public IIterator<TPoint> {
public:
    TListIterator(TContainer points)
        : Points_(std::move(points))
        , Begin_{Points_.begin()}
        , End_{Points_.end()}
    {
    }

public:
    bool NextPoint(TPoint* point) override {
        if (Begin_ == End_) {
            return false;
        }

        *point = *Begin_++;

        return true;
    }

private:
    TContainer Points_;
    typename TContainer::const_iterator Begin_;
    typename TContainer::const_iterator End_;
};

template <typename TPoint, typename... TArgs, template <typename, typename...> typename TContainer>
TListIterator(TContainer<TPoint, TArgs...>) -> TListIterator<TPoint, TContainer<TPoint, TArgs...>>;

} // namespace NSolomon::NTsModel
