#pragma once

#include "iterator.h"

namespace NSolomon::NTsModel {

namespace NPrivate {

template <typename T>
struct TPointerTraits {
    using TIt = typename std::pointer_traits<T>::element_type;
    static_assert(IsIteratorV<TIt>, "expected an iterator");

    using TPoint = typename TIt::TPoint;
};

} // namespace NPrivate

/**
 * A (smart) pointer to an iterator. Allows using a non-owned reference or a smart pointer in places where
 * an owned instance of an iterator is expected.
 *
 * For example, `TGaugeDerivative<It>` accepts an underlying iterator by-value. If you want to pass a reference to it,
 * use `TGaugeDerivative<TIteratorPtr<It*>>`.
 */
template <typename TPtr>
class TIteratorPtr: public IIterator<typename NPrivate::TPointerTraits<TPtr>::TPoint> {
public:
    explicit TIteratorPtr(TPtr ptr)
        : Underlying_(std::move(ptr))
    {
    }

public:
    bool NextPoint(typename NPrivate::TPointerTraits<TPtr>::TPoint* point) override {
        return Underlying_->NextPoint(point);
    }

private:
    TPtr Underlying_;
};

} // namespace NSolomon::NTsModel
