#include "loghist_to_hist_iterator.h"

#include <library/cpp/monlib/metrics/log_histogram_snapshot.h>

#include <solomon/services/memstore/lib/slog/error.h>
#include <solomon/services/memstore/lib/yasm/yasm.h>

namespace NSolomon::NTsModel {

TLogHistToHistIterator::TLogHistToHistIterator(NTsModel::IIterator<NTsModel::TLogHistPoint>* data)
    : Data_{data}
{
}

bool TLogHistToHistIterator::NextPoint(NTsModel::THistPoint* point) {
    if (!Data_->NextPoint(&Point_)) {
        return false;
    }
    static_cast<NTs::TPointCommon&>(*point) = static_cast<NTs::TPointCommon&>(Point_);

    NMemStore::NYasm::TUgramBuilder builder;
    builder.AddBucket(0.0, 0.0, Point_.ZeroCount);

    double bound = std::pow(Point_.Base, Point_.StartPower);
    if (Point_.Values.size() > NMonitoring::LOG_HIST_MAX_BUCKETS) {
        ythrow yexception() << "too many buckets in a log histogram: " << Point_.Values.size();
    }
    for (auto value: Point_.Values) {
        builder.AddBucket(bound, value);
        bound *= Point_.Base;
    }
    point->Buckets = builder.ReleaseBuckets();
    return true;
}

} // namespace NSolomon::NTsModel
