#pragma once

#include "points.h"

namespace NSolomon::NTsModel {

/**
 * Merge the left point into the right point from the same time series.
 *
 * These functions inspect `Merge` and `Count` parameters to determine whether points should be merged or not.
 */
void Merge(const TGaugePoint& l, TGaugePoint* r);
void Merge(const TCounterPoint& l, TCounterPoint* r);
void Merge(const TRatePoint& l, TRatePoint* r);
void Merge(const TIGaugePoint& l, TIGaugePoint* r);
void Merge(const THistPoint& l, THistPoint* r);
void Merge(const THistRatePoint& l, THistRatePoint* r);
void Merge(const TDSummaryPoint& l, TDSummaryPoint* r);
void Merge(const TLogHistPoint& l, TLogHistPoint* r);

/**
 * Merge the left point into the right point.
 *
 * These functions are implementations for `Merge` above. They don't check point's `Merge` flag
 * and don't update point's `Count` flag. They also work with point value classes which means they are less typesafe.
 */
void MergeRaw(const NTs::TDoublePoint::TValue& l, NTs::TDoublePoint::TValue* r);
void MergeRaw(const NTs::TLongPoint::TValue& l, NTs::TLongPoint::TValue* r);
void MergeRaw(const NTs::THistogramPoint::TValue& l, NTs::THistogramPoint::TValue* r);
void MergeRaw(const NTs::TLogHistogramPoint::TValue& l, NTs::TLogHistogramPoint::TValue* r);
void MergeRaw(const NTs::TSummaryIntPoint::TValue& l, NTs::TSummaryIntPoint::TValue* r);
void MergeRaw(const NTs::TSummaryDoublePoint::TValue& l, NTs::TSummaryDoublePoint::TValue* r);

} // namespace NSolomon::NTsModel
