#include "point_columns.h"

#include <util/string/cast.h>

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::TPointColumns, os, type) {
    os << "{";
    TStringBuf sep;
    for (ui8 column = 0; column < NSolomon::NTsModel::TPointColumns::NumColumns; ++column) {
        if (type.HasColumn(static_cast<NSolomon::NTsModel::TPointColumns::EColumn>(column))) {
            os << sep << static_cast<NSolomon::NTsModel::TPointColumns::EColumn>(column);
            sep = ", ";
        }
    }
    os << "}";
}

namespace NSolomon::NTsModel {

std::ostream& operator<<(std::ostream& os, TPointColumns type) {
    return os << ToString(type);
}

NSolomon::NTs::TColumnSet TPointColumns::ToColumnSet(EPointType type) const {
    NSolomon::NTs::TColumnSet columns{NTs::EColumn::TS};

    switch (type) {
        case NTsModel::EPointType::Unknown:
            break;
        case EPointType::DGauge:
            columns = columns.With(NTs::EColumn::VALUE);
            break;
        case EPointType::IGauge:
            columns = columns.With(NTs::EColumn::LONG_VALUE);
            break;
        case EPointType::Counter:
            columns = columns.With(NTs::EColumn::LONG_VALUE);
            break;
        case EPointType::Rate:
            columns = columns.With(NTs::EColumn::LONG_VALUE);
            break;
        case EPointType::Hist:
            columns = columns.With(NTs::EColumn::HISTOGRAM);
            break;
        case EPointType::HistRate:
            columns = columns.With(NTs::EColumn::HISTOGRAM);
            break;
        case EPointType::LogHist:
            columns = columns.With(NTs::EColumn::LOG_HISTOGRAM);
            break;
        case EPointType::DSummary:
            columns = columns.With(NTs::EColumn::DSUMMARY);
            break;
    }

    for (ui8 column = 0; column < NSolomon::NTsModel::TPointColumns::NumColumns; ++column) {
        if (HasColumn(static_cast<NSolomon::NTsModel::TPointColumns::EColumn>(column))) {
            switch (static_cast<NSolomon::NTsModel::TPointColumns::EColumn>(column)) {
                case Step:
                    columns = columns.With(NTs::EColumn::STEP);
                    break;
                case Merge:
                    columns = columns.With(NTs::EColumn::MERGE);
                    break;
                case Count:
                    columns = columns.With(NTs::EColumn::COUNT);
                    break;
                case NumColumns:
                    break;
            }
        }
    }

    return columns;
}

} // namespace NSolomon::NTsModel
