#include "point_type.h"

#include <util/string/cast.h>

namespace NSolomon::NTsModel {

TErrorOr<EPointType, TString> FromProto(yandex::solomon::model::MetricType type) {
    switch (type) {
        case yandex::solomon::model::DGAUGE:
            return EPointType::DGauge;
        case yandex::solomon::model::IGAUGE:
            return EPointType::IGauge;
        case yandex::solomon::model::COUNTER:
            return EPointType::Counter;
        case yandex::solomon::model::RATE:
            return EPointType::Rate;
        case yandex::solomon::model::HIST:
            return EPointType::Hist;
        case yandex::solomon::model::HIST_RATE:
            return EPointType::HistRate;
        case yandex::solomon::model::ISUMMARY:
            return TErrorOr<EPointType, TString>::FromError("ISummary is not supported");
        case yandex::solomon::model::DSUMMARY:
            return EPointType::DSummary;
        case yandex::solomon::model::LOG_HISTOGRAM:
            return EPointType::LogHist;
        default:
            return TErrorOr<EPointType, TString>::FromError("unknown metric type " + ToString(static_cast<int>(type)));
    }
}

yandex::solomon::model::MetricType ToProto(EPointType type) {
    switch (type) {
        case EPointType::Unknown:
            return yandex::solomon::model::MetricType::METRIC_TYPE_UNSPECIFIED;
        case EPointType::DGauge:
            return yandex::solomon::model::MetricType::DGAUGE;
        case EPointType::IGauge:
            return yandex::solomon::model::MetricType::IGAUGE;
        case EPointType::Counter:
            return yandex::solomon::model::MetricType::COUNTER;
        case EPointType::Rate:
            return yandex::solomon::model::MetricType::RATE;
        case EPointType::Hist:
            return yandex::solomon::model::MetricType::HIST;
        case EPointType::HistRate:
            return yandex::solomon::model::MetricType::HIST_RATE;
        case EPointType::LogHist:
            return yandex::solomon::model::MetricType::LOG_HISTOGRAM;
        case EPointType::DSummary:
            return yandex::solomon::model::MetricType::DSUMMARY;
    }
}

std::ostream& operator<<(std::ostream& os, EPointType type) {
    return os << ToString(type);
}

} // namespace NSolomon::NTsModel
