#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>
#include <solomon/protos/model/metric.pb.h>

#include <util/system/types.h>

#include <ostream>

namespace NSolomon::NTsModel {

/**
 * Basic point type. These correspond to classes in `points.h`.
 */
enum class EPointType: ui8 {
    Unknown,
    DGauge,
    IGauge,
    Counter,
    Rate,
    Hist,
    HistRate,
    LogHist,
    DSummary,
    // ISummary = 8, // not implemented yet
};

/**
 * Convert proto enum to `EPointType`.
 */
TErrorOr<EPointType, TString> FromProto(yandex::solomon::model::MetricType type);
yandex::solomon::model::MetricType ToProto(EPointType type);

std::ostream& operator<<(std::ostream& os, EPointType type);

} // namespace NSolomon::NTsModel
