#include "points.h"

#include <util/string/cast.h>

#include <algorithm>

namespace NSolomon::NTsModel {

bool operator==(const TGaugePoint& lhs, const TGaugePoint& rhs) {
    return
        lhs.Time == rhs.Time &&
        (lhs.Num == rhs.Num || std::isnan(lhs.Num) && std::isnan(rhs.Num)) &&
        lhs.Denom == rhs.Denom &&
        lhs.Step == rhs.Step &&
        lhs.Merge == rhs.Merge &&
        lhs.Count == rhs.Count;
}

bool operator==(const TCounterPoint& lhs, const TCounterPoint& rhs) {
    return
        lhs.Time == rhs.Time &&
        lhs.Value == rhs.Value &&
        lhs.Step == rhs.Step &&
        lhs.Merge == rhs.Merge &&
        lhs.Count == rhs.Count;
}

bool operator==(const TRatePoint& lhs, const TRatePoint& rhs) {
    return
        lhs.Time == rhs.Time &&
        lhs.Value == rhs.Value &&
        lhs.Step == rhs.Step &&
        lhs.Merge == rhs.Merge &&
        lhs.Count == rhs.Count;
}

bool operator==(const TIGaugePoint& lhs, const TIGaugePoint& rhs) {
    return
        lhs.Time == rhs.Time &&
        lhs.Value == rhs.Value &&
        lhs.Step == rhs.Step &&
        lhs.Merge == rhs.Merge &&
        lhs.Count == rhs.Count;
}

bool operator==(const THistPoint& lhs, const THistPoint& rhs) {
    return
        lhs.Time == rhs.Time &&
        std::equal(
            lhs.Buckets.begin(), lhs.Buckets.end(),
            rhs.Buckets.begin(), rhs.Buckets.end(),
            [](const auto& l, const auto& r) { return l.UpperBound == r.UpperBound && l.Value == r.Value; }) &&
        lhs.Denom == rhs.Denom &&
        lhs.Step == rhs.Step &&
        lhs.Merge == rhs.Merge &&
        lhs.Count == rhs.Count;
}

bool operator==(const THistRatePoint& lhs, const THistRatePoint& rhs) {
    return
        lhs.Time == rhs.Time &&
        std::equal(
            lhs.Buckets.begin(), lhs.Buckets.end(),
            rhs.Buckets.begin(), rhs.Buckets.end(),
            [](const auto& l, const auto& r) { return l.UpperBound == r.UpperBound && l.Value == r.Value; }) &&
        lhs.Denom == rhs.Denom &&
        lhs.Step == rhs.Step &&
        lhs.Merge == rhs.Merge &&
        lhs.Count == rhs.Count;
}

bool operator==(const TDSummaryPoint& lhs, const TDSummaryPoint& rhs) {
    return
        lhs.Time == rhs.Time &&
        lhs.CountValue == rhs.CountValue &&
        (lhs.Sum == rhs.Sum || std::isnan(lhs.Sum) && std::isnan(rhs.Sum)) &&
        (lhs.Min == rhs.Min || std::isnan(lhs.Min) && std::isnan(rhs.Min)) &&
        (lhs.Max == rhs.Max || std::isnan(lhs.Max) && std::isnan(rhs.Max)) &&
        (lhs.Last == rhs.Last || std::isnan(lhs.Last) && std::isnan(rhs.Last)) &&
        lhs.Step == rhs.Step &&
        lhs.Merge == rhs.Merge &&
        lhs.Count == rhs.Count;
}

bool operator==(const TLogHistPoint& lhs, const TLogHistPoint& rhs) {
    return
        lhs.Time == rhs.Time &&
        lhs.Values == rhs.Values &&
        lhs.ZeroCount == rhs.ZeroCount &&
        lhs.StartPower == rhs.StartPower &&
        lhs.MaxBucketCount == rhs.MaxBucketCount &&
        lhs.Base == rhs.Base &&
        lhs.Step == rhs.Step &&
        lhs.Merge == rhs.Merge &&
        lhs.Count == rhs.Count;
}

bool operator!=(const TGaugePoint& lhs, const TGaugePoint& rhs) {
    return !(lhs == rhs);
}

bool operator!=(const TCounterPoint& lhs, const TCounterPoint& rhs) {
    return !(lhs == rhs);
}

bool operator!=(const TRatePoint& lhs, const TRatePoint& rhs) {
    return !(lhs == rhs);
}

bool operator!=(const TIGaugePoint& lhs, const TIGaugePoint& rhs) {
    return !(lhs == rhs);
}

bool operator!=(const THistPoint& lhs, const THistPoint& rhs) {
    return !(lhs == rhs);
}

bool operator!=(const THistRatePoint& lhs, const THistRatePoint& rhs) {
    return !(lhs == rhs);
}

bool operator!=(const TDSummaryPoint& lhs, const TDSummaryPoint& rhs) {
    return !(lhs == rhs);
}

bool operator!=(const TLogHistPoint& lhs, const TLogHistPoint& rhs) {
    return !(lhs == rhs);
}

std::ostream& operator<<(std::ostream& os, const TGaugePoint& point) {
    return os << ToString(point);
}

std::ostream& operator<<(std::ostream& os, const TCounterPoint& point) {
    return os << ToString(point);
}

std::ostream& operator<<(std::ostream& os, const TRatePoint& point) {
    return os << ToString(point);
}

std::ostream& operator<<(std::ostream& os, const TIGaugePoint& point) {
    return os << ToString(point);
}

std::ostream& operator<<(std::ostream& os, const THistPoint& point) {
    return os << ToString(point);
}

std::ostream& operator<<(std::ostream& os, const THistRatePoint& point) {
    return os << ToString(point);
}

std::ostream& operator<<(std::ostream& os, const TDSummaryPoint& point) {
    return os << ToString(point);
}

std::ostream& operator<<(std::ostream& os, const TLogHistPoint& point) {
    return os << ToString(point);
}

} // namespace NSolomon::NTsModel

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::TGaugePoint, os, point) {
    os
        << "{"
        << "time=" << point.Time.ToString() << ", "
        << "num=" << point.Num << ", "
        << "denom=" << point.Denom << ", "
        << "step=" << point.Step.ToString() << ", "
        << "merge=" << point.Merge << ", "
        << "count=" << point.Count
        << "}";
}

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::TCounterPoint, os, point) {
    os
        << "{"
        << "time=" << point.Time.ToString() << ", "
        << "value=" << point.Value << ", "
        << "step=" << point.Step.ToString() << ", "
        << "merge=" << point.Merge << ", "
        << "count=" << point.Count
        << "}";
}

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::TRatePoint, os, point) {
    os
        << "{"
        << "time=" << point.Time.ToString() << ", "
        << "value=" << point.Value << ", "
        << "step=" << point.Step.ToString() << ", "
        << "merge=" << point.Merge << ", "
        << "count=" << point.Count
        << "}";
}

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::TIGaugePoint, os, point) {
    os
        << "{"
        << "time=" << point.Time.ToString() << ", "
        << "value=" << point.Value << ", "
        << "step=" << point.Step.ToString() << ", "
        << "merge=" << point.Merge << ", "
        << "count=" << point.Count
        << "}";
}

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::THistPoint, os, point) {
    os
        << "{"
        << "time=" << point.Time.ToString() << ", "
        << "buckets={";
    bool sep = false;
    for (auto bucket: point.Buckets) {
        if (sep) {
            os << ", ";
        }

        os << "{" << bucket.UpperBound << ", " << bucket.Value << "}";

        sep = true;
    }
    os
        << "}, "
        << "denom=" << point.Denom << ", "
        << "step=" << point.Step.ToString() << ", "
        << "merge=" << point.Merge << ", "
        << "count=" << point.Count
        << "}";
}

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::THistRatePoint, os, point) {
    os
        << "{"
        << "time=" << point.Time.ToString() << ", "
        << "buckets={";
    bool sep = false;
    for (auto bucket: point.Buckets) {
        if (sep) {
            os << ", ";
        }

        os << "{" << bucket.UpperBound << ", " << bucket.Value << "}";

        sep = true;
    }
    os
        << "}, "
        << "denom=" << point.Denom << ", "
        << "step=" << point.Step.ToString() << ", "
        << "merge=" << point.Merge << ", "
        << "count=" << point.Count
        << "}";
}

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::TDSummaryPoint, os, point) {
    os
        << "{"
        << "time=" << point.Time.ToString() << ", "
        << "count_value=" << point.CountValue << ", "
        << "sum=" << point.Sum << ", "
        << "min=" << point.Min << ", "
        << "max=" << point.Max << ", "
        << "last=" << point.Last << ", "
        << "step=" << point.Step.ToString() << ", "
        << "merge=" << point.Merge << ", "
        << "count=" << point.Count
        << "}";
}

Y_DECLARE_OUT_SPEC(, NSolomon::NTsModel::TLogHistPoint, os, point) {
    os
        << "{"
        << "time=" << point.Time.ToString() << ", "
        << "zero_count=" << point.ZeroCount << ", "
        << "start_power=" << point.StartPower << ", "
        << "max_bucket_count=" << point.MaxBucketCount << ", "
        << "values={";
    bool sep = false;
    for (auto value: point.Values) {
        if (sep) {
            os << ", ";
        }

        os << value;

        sep = true;
    }
    os
        << "}, "
        << "base=" << point.Base << ", "
        << "step=" << point.Step.ToString() << ", "
        << "merge=" << point.Merge << ", "
        << "count=" << point.Count
        << "}";
}
