#pragma once

#include "point_type.h"

#include <solomon/libs/cpp/ts_codec/counter_ts_codec.h>
#include <solomon/libs/cpp/ts_codec/double_ts_codec.h>
#include <solomon/libs/cpp/ts_codec/gauge_int_ts_codec.h>
#include <solomon/libs/cpp/ts_codec/hist_log_ts_codec.h>
#include <solomon/libs/cpp/ts_codec/hist_ts_codec.h>
#include <solomon/libs/cpp/ts_codec/points.h>
#include <solomon/libs/cpp/ts_codec/summary_double_ts_codec.h>

#include <ostream>

namespace NSolomon::NTsModel {

namespace NPrivate {

struct TPointTag {};

} // NPrivate

/**
 * A `Gauge` point.
 */
struct TGaugePoint: public NSolomon::NTs::TDoublePoint, public NPrivate::TPointTag {
    static constexpr const EPointType Type = EPointType::DGauge;
    using TDataType = NSolomon::NTs::TDoublePoint;

    friend bool operator==(const TGaugePoint& lhs, const TGaugePoint& rhs);
    friend bool operator!=(const TGaugePoint& lhs, const TGaugePoint& rhs);
    friend std::ostream& operator<<(std::ostream& os, const TGaugePoint& point);
};

/**
 * A `Counter` point.
 */
struct TCounterPoint: public NSolomon::NTs::TLongPoint, public NPrivate::TPointTag {
    static constexpr const EPointType Type = EPointType::Counter;
    using TDataType = NSolomon::NTs::TLongPoint;

    friend bool operator==(const TCounterPoint& lhs, const TCounterPoint& rhs);
    friend bool operator!=(const TCounterPoint& lhs, const TCounterPoint& rhs);
    friend std::ostream& operator<<(std::ostream& os, const TCounterPoint& point);
};

/**
 * A `Rate` point.
 */
struct TRatePoint: public NSolomon::NTs::TLongPoint, public NPrivate::TPointTag {
    static constexpr const EPointType Type = EPointType::Rate;
    using TDataType = NSolomon::NTs::TLongPoint;

    friend bool operator==(const TRatePoint& lhs, const TRatePoint& rhs);
    friend bool operator!=(const TRatePoint& lhs, const TRatePoint& rhs);
    friend std::ostream& operator<<(std::ostream& os, const TRatePoint& point);
};

/**
 * A `IGauge` point.
 */
struct TIGaugePoint: public NSolomon::NTs::TLongPoint, public NPrivate::TPointTag {
    static constexpr const EPointType Type = EPointType::IGauge;
    using TDataType = NSolomon::NTs::TLongPoint;

    friend bool operator==(const TIGaugePoint& lhs, const TIGaugePoint& rhs);
    friend bool operator!=(const TIGaugePoint& lhs, const TIGaugePoint& rhs);
    friend std::ostream& operator<<(std::ostream& os, const TIGaugePoint& point);
};

/**
 * A `Hist` point.
 */
struct THistPoint: public NSolomon::NTs::THistogramPoint, public NPrivate::TPointTag {
    static constexpr const EPointType Type = EPointType::Hist;
    using TDataType = NSolomon::NTs::THistogramPoint;

    friend bool operator==(const THistPoint& lhs, const THistPoint& rhs);
    friend bool operator!=(const THistPoint& lhs, const THistPoint& rhs);
    friend std::ostream& operator<<(std::ostream& os, const THistPoint& point);
};

/**
 * A `HistRate` point.
 */
struct THistRatePoint: public NSolomon::NTs::THistogramPoint, public NPrivate::TPointTag {
    static constexpr const EPointType Type = EPointType::HistRate;
    using TDataType = NSolomon::NTs::THistogramPoint;

    friend bool operator==(const THistRatePoint& lhs, const THistRatePoint& rhs);
    friend bool operator!=(const THistRatePoint& lhs, const THistRatePoint& rhs);
    friend std::ostream& operator<<(std::ostream& os, const THistRatePoint& point);
};

/**
 * A `DSummary` point.
 */
struct TDSummaryPoint: public NSolomon::NTs::TSummaryDoublePoint, public NPrivate::TPointTag {
    static constexpr const EPointType Type = EPointType::DSummary;
    using TDataType = NSolomon::NTs::TSummaryDoublePoint;

    friend bool operator==(const TDSummaryPoint& lhs, const TDSummaryPoint& rhs);
    friend bool operator!=(const TDSummaryPoint& lhs, const TDSummaryPoint& rhs);
    friend std::ostream& operator<<(std::ostream& os, const TDSummaryPoint& point);
};

/**
 * A `LogHist` point.
 */
struct TLogHistPoint: public NSolomon::NTs::TLogHistogramPoint, public NPrivate::TPointTag {
    static constexpr const EPointType Type = EPointType::LogHist;
    using TDataType = NSolomon::NTs::TLogHistogramPoint;

    friend bool operator==(const TLogHistPoint& lhs, const TLogHistPoint& rhs);
    friend bool operator!=(const TLogHistPoint& lhs, const TLogHistPoint& rhs);
    friend std::ostream& operator<<(std::ostream& os, const TLogHistPoint& point);
};

/**
 * Check if the given type `T` is a point.
 */
template <typename T>
static constexpr const bool IsPointV = std::is_base_of_v<NPrivate::TPointTag, T>;

} // namespace NSolomon::NTsModel
