#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/ts_model/iterator_cat.h>
#include <solomon/libs/cpp/ts_model/iterator_list.h>
#include <solomon/libs/cpp/ts_model/testlib/testlib.h>

using namespace NSolomon::NTsModel;
using namespace NSolomon::NTs;

TEST(IteratorCat, Empty) {
    TCatIterator<TListIterator<TGaugePoint>> it{};

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{}});
}

TEST(IteratorCat, One) {
    TCatIterator<TListIterator<TGaugePoint>> it{};
    it.Append(TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
        Gauge("2020-01-01T00:00:20Z", 20, 0)
    }});

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
        Gauge("2020-01-01T00:00:20Z", 20, 0)
    }});
}

TEST(IteratorCat, Some) {
    TCatIterator<TListIterator<TGaugePoint>> it{};
    it.Append(TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
    }});
    it.Append(TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:15Z", 15, 0),
        Gauge("2020-01-01T00:00:20Z", 20, 0)
    }});

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
        Gauge("2020-01-01T00:00:20Z", 20, 0)
    }});
}

TEST(IteratorCat, EmptyMiddle) {
    TCatIterator<TListIterator<TGaugePoint>> it{};
    it.Append(TListIterator<TGaugePoint>{{}});
    it.Append(TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
    }});
    it.Append(TListIterator<TGaugePoint>{{}});
    it.Append(TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:15Z", 15, 0),
        Gauge("2020-01-01T00:00:20Z", 20, 0)
    }});
    it.Append(TListIterator<TGaugePoint>{{}});

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
        Gauge("2020-01-01T00:00:20Z", 20, 0)
    }});
}
