#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/ts_model/iterator_crop.h>
#include <solomon/libs/cpp/ts_model/iterator_list.h>
#include <solomon/libs/cpp/ts_model/testlib/testlib.h>

using namespace NSolomon::NTsModel;
using namespace NSolomon::NTs;

static const auto MinTs = TInstant::ParseIso8601("2020-01-01T00:00:10");
static const auto MaxTs = TInstant::ParseIso8601("2020-01-01T00:00:20");

TEST(IteratorCrop, Empty) {
    TCropIterator<TListIterator<TGaugePoint>> it{{{}}, MinTs, MaxTs};

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{}});
}

TEST(IteratorCrop, NoDrop) {
    TCropIterator<TListIterator<TGaugePoint>> it{{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
    }}, MinTs, MaxTs};

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
    }});
}

TEST(IteratorCrop, DropBefore) {
    TCropIterator<TListIterator<TGaugePoint>> it{{{
        Gauge("2020-01-01T00:00:00Z", 0, 0),
        Gauge("2020-01-01T00:00:05Z", 5, 0),
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
    }}, MinTs, MaxTs};

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
    }});
}

TEST(IteratorCrop, DropAfter) {
    TCropIterator<TListIterator<TGaugePoint>> it{{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
        Gauge("2020-01-01T00:00:20Z", 20, 0),
        Gauge("2020-01-01T00:00:25Z", 25, 0),
        Gauge("2020-01-01T00:00:30Z", 30, 0)
    }}, MinTs, MaxTs};

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
    }});
}

TEST(IteratorCrop, DropBeforeAndAfter) {
    TCropIterator<TListIterator<TGaugePoint>> it{{{
        Gauge("2020-01-01T00:00:00Z", 0, 0),
        Gauge("2020-01-01T00:00:05Z", 5, 0),
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
        Gauge("2020-01-01T00:00:20Z", 20, 0),
        Gauge("2020-01-01T00:00:25Z", 25, 0),
        Gauge("2020-01-01T00:00:30Z", 30, 0)
    }}, MinTs, MaxTs};

    ExpectIteratorsEq(std::move(it), TListIterator<TGaugePoint>{{
        Gauge("2020-01-01T00:00:10Z", 10, 0),
        Gauge("2020-01-01T00:00:15Z", 15, 0),
    }});
}
