#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/ts_model/point_columns.h>

#include <util/string/cast.h>

using namespace NSolomon::NTsModel;

TEST(PointType, ExtendedToString) {
    EXPECT_EQ(ToString(TPointColumns{}), "{}");
    EXPECT_EQ(ToString(TPointColumns{TPointColumns::Merge}), "{Merge}");
    EXPECT_EQ(ToString(TPointColumns{TPointColumns::Merge, TPointColumns::Count}), "{Merge, Count}");
}

TEST(PointType, Eq) {
    EXPECT_TRUE((TPointColumns{} == TPointColumns{}));
    EXPECT_TRUE((TPointColumns{TPointColumns::Merge} == TPointColumns{TPointColumns::Merge}));
    EXPECT_TRUE((TPointColumns{TPointColumns::Merge} != TPointColumns{TPointColumns::Count}));
    EXPECT_TRUE((TPointColumns{TPointColumns::Merge} != TPointColumns{TPointColumns::Merge, TPointColumns::Count}));
}

TEST(PointType, And) {
    EXPECT_EQ(
        (TPointColumns{} & TPointColumns{}),
        (TPointColumns{}));
    EXPECT_EQ(
        (TPointColumns{} & TPointColumns{TPointColumns::Merge}),
        (TPointColumns{}));
    EXPECT_EQ(
        (TPointColumns{TPointColumns::Merge} & TPointColumns{TPointColumns::Merge}),
        (TPointColumns{TPointColumns::Merge}));
    EXPECT_EQ(
        (TPointColumns{TPointColumns::Merge, TPointColumns::Count} & TPointColumns{TPointColumns::Merge}),
        (TPointColumns{TPointColumns::Merge}));
}

TEST(PointType, Or) {
    EXPECT_EQ(
        (TPointColumns{} | TPointColumns{}),
        (TPointColumns{}));
    EXPECT_EQ(
        (TPointColumns{TPointColumns::Merge} | TPointColumns{}),
        (TPointColumns{TPointColumns::Merge}));
    EXPECT_EQ(
        (TPointColumns{} | TPointColumns{TPointColumns::Count}),
        (TPointColumns{TPointColumns::Count}));
    EXPECT_EQ(
        (TPointColumns{TPointColumns::Merge} | TPointColumns{TPointColumns::Count}),
        (TPointColumns{TPointColumns::Merge, TPointColumns::Count}));
}

TEST(PointType, Xor) {
    EXPECT_EQ(
        (TPointColumns{} ^ TPointColumns{}),
        (TPointColumns{}));
    EXPECT_EQ(
        (TPointColumns{TPointColumns::Merge, TPointColumns::Count, TPointColumns::Step} ^ TPointColumns{}),
        (TPointColumns{TPointColumns::Merge, TPointColumns::Count, TPointColumns::Step}));
    EXPECT_EQ(
        (TPointColumns{} ^ TPointColumns{TPointColumns::Merge, TPointColumns::Count, TPointColumns::Step}),
        (TPointColumns{TPointColumns::Merge, TPointColumns::Count, TPointColumns::Step}));
    EXPECT_EQ(
        (TPointColumns{TPointColumns::Merge, TPointColumns::Count} ^ TPointColumns{TPointColumns::Merge}),
        (TPointColumns{TPointColumns::Count}));
}

TEST(PointType, Not) {
    EXPECT_EQ(
        (~TPointColumns{TPointColumns::Step, TPointColumns::Merge, TPointColumns::Count}),
        (TPointColumns{}));
    EXPECT_EQ(
        (~TPointColumns{}),
        (TPointColumns{TPointColumns::Step, TPointColumns::Merge, TPointColumns::Count}));
}

TEST(PointType, Setter) {
    auto ty = TPointColumns{};
    EXPECT_EQ(ty.WithStep(), (TPointColumns{TPointColumns::Step}));
    EXPECT_EQ(ty.WithMerge(), (TPointColumns{TPointColumns::Merge}));
    EXPECT_EQ(ty.WithCount(), (TPointColumns{TPointColumns::Count}));
    EXPECT_EQ(ty, (TPointColumns{}));

    ty.SetStep();
    EXPECT_EQ(ty, (TPointColumns{TPointColumns::Step}));
    EXPECT_TRUE(ty.HasStep());
    EXPECT_FALSE(ty.HasMerge());
    EXPECT_FALSE(ty.HasCount());
    ty.SetStep(false);
    EXPECT_EQ(ty, (TPointColumns{}));
    EXPECT_FALSE(ty.HasStep());
    EXPECT_FALSE(ty.HasMerge());
    EXPECT_FALSE(ty.HasCount());

    ty.SetMerge();
    EXPECT_EQ(ty, (TPointColumns{TPointColumns::Merge}));
    EXPECT_FALSE(ty.HasStep());
    EXPECT_TRUE(ty.HasMerge());
    EXPECT_FALSE(ty.HasCount());
    ty.SetMerge(false);
    EXPECT_EQ(ty, (TPointColumns{}));
    EXPECT_FALSE(ty.HasStep());
    EXPECT_FALSE(ty.HasMerge());
    EXPECT_FALSE(ty.HasCount());

    ty.SetCount();
    EXPECT_EQ(ty, (TPointColumns{TPointColumns::Count}));
    EXPECT_FALSE(ty.HasStep());
    EXPECT_FALSE(ty.HasMerge());
    EXPECT_TRUE(ty.HasCount());
    ty.SetCount(false);
    EXPECT_EQ(ty, (TPointColumns{}));
    EXPECT_FALSE(ty.HasStep());
    EXPECT_FALSE(ty.HasMerge());
    EXPECT_FALSE(ty.HasCount());
}
