#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/ts_model/point_type.h>

#include <util/string/cast.h>

using namespace NSolomon::NTsModel;

TEST(PointType, SimpleToString) {
    EXPECT_EQ(ToString(EPointType::DGauge), "DGauge");
    EXPECT_EQ(ToString(EPointType::IGauge), "IGauge");
    EXPECT_EQ(ToString(EPointType::Counter), "Counter");
    EXPECT_EQ(ToString(EPointType::Rate), "Rate");
    EXPECT_EQ(ToString(EPointType::Hist), "Hist");
    EXPECT_EQ(ToString(EPointType::HistRate), "HistRate");
    EXPECT_EQ(ToString(EPointType::LogHist), "LogHist");
    EXPECT_EQ(ToString(EPointType::DSummary), "DSummary");
}

TEST(PointType, SimpleFromProto) {
#define EXPECT_OK(A, B) { auto res = (A); EXPECT_TRUE(res.Success()); if (res.Success()) EXPECT_EQ(res.Value(), (B)); }
#define EXPECT_ERR(A, B) { auto res = (A); EXPECT_TRUE(res.Fail()); if (res.Fail()) EXPECT_EQ(res.Error(), (B)); }
    EXPECT_ERR(FromProto(yandex::solomon::model::METRIC_TYPE_UNSPECIFIED), "unknown metric type 0");
    EXPECT_OK(FromProto(yandex::solomon::model::DGAUGE), EPointType::DGauge);
    EXPECT_OK(FromProto(yandex::solomon::model::IGAUGE), EPointType::IGauge);
    EXPECT_OK(FromProto(yandex::solomon::model::COUNTER), EPointType::Counter);
    EXPECT_OK(FromProto(yandex::solomon::model::RATE), EPointType::Rate);
    EXPECT_OK(FromProto(yandex::solomon::model::HIST), EPointType::Hist);
    EXPECT_OK(FromProto(yandex::solomon::model::HIST_RATE), EPointType::HistRate);
    EXPECT_ERR(FromProto(yandex::solomon::model::ISUMMARY), "ISummary is not supported");
    EXPECT_OK(FromProto(yandex::solomon::model::DSUMMARY), EPointType::DSummary);
    EXPECT_OK(FromProto(yandex::solomon::model::LOG_HISTOGRAM), EPointType::LogHist);
    EXPECT_ERR(FromProto(yandex::solomon::model::MetricType(100)), "unknown metric type 100");
#undef EXPECT_OK
#undef EXPECT_ERR
}
