#pragma once

#include "point_traits.h"

namespace NSolomon::NTsModel {

/**
 * Based on the given point type, call `functor` with an appropriate `TPointTraits` as the first argument,
 * passing additional arguments from `args`.
 *
 * This function fails if metric type is `UNKNOWN`.
 */
template <typename F, typename... Args>
decltype(auto) Visit(EPointType type, F&& functor, Args&&... args) {
    switch (type) {
        case EPointType::Unknown:
            Y_FAIL("cannot visit metric with unknown type");
        case EPointType::DGauge:
            return std::forward<F>(functor)(TPointTraits<TGaugePoint>{}, std::forward<Args>(args)...);
        case EPointType::Counter:
            return std::forward<F>(functor)(TPointTraits<TCounterPoint>{}, std::forward<Args>(args)...);
        case EPointType::Rate:
            return std::forward<F>(functor)(TPointTraits<TRatePoint>{}, std::forward<Args>(args)...);
        case EPointType::IGauge:
            return std::forward<F>(functor)(TPointTraits<TIGaugePoint>{}, std::forward<Args>(args)...);
        case EPointType::Hist:
            return std::forward<F>(functor)(TPointTraits<THistPoint>{}, std::forward<Args>(args)...);
        case EPointType::HistRate:
            return std::forward<F>(functor)(TPointTraits<THistRatePoint>{}, std::forward<Args>(args)...);
        case EPointType::DSummary:
            return std::forward<F>(functor)(TPointTraits<TDSummaryPoint>{}, std::forward<Args>(args)...);
        case EPointType::LogHist:
            return std::forward<F>(functor)(TPointTraits<TLogHistPoint>{}, std::forward<Args>(args)...);
    }
}

} // namespace NSolomon::NTsModel
