#include "convertion.h"

#include <solomon/libs/cpp/labels/known_keys.h>
#include <solomon/libs/cpp/yasm/constants/labels.h>

namespace NSolomon::NYasm {

namespace {

class TYasmKeyBuilder {
public:
    explicit TYasmKeyBuilder(TStringBuf itype) {
        RequestKeyBuilder_ << "itype=" << itype;
    }

    void Add(TStringBuf key, TStringBuf value) {
        if (key == NLabels::LABEL_PROJECT || key == NLabels::LABEL_SERVICE || key == NLabels::LABEL_CLUSTER ||
            value == AGGREGATED_MARKER)
        {
            return;
        }

        if (key == LABEL_SIGNAL) {
            SignalName_ = NZoom::NSignal::TSignalName{value};
            return;
        }

        // if the `host` label is specified, use host. Use group otherwise
        if (key == NLabels::LABEL_GROUP && !HostName_) {
            HostName_ = NZoom::NHost::THostName{value};
        } else if (key == NLabels::LABEL_HOST) {
            HostName_ = NZoom::NHost::THostName{value};
        }

        RequestKeyBuilder_ << ';';
        RequestKeyBuilder_ << key << '=' << value;
    }

    TYasmKey Build() const {
        NZoom::NSubscription::TInternedRequestKey requestKey{RequestKeyBuilder_};
        Y_ENSURE(HostName_, "unable to determine host name");
        Y_ENSURE(SignalName_, "unable to determine signal name");

        return {*HostName_, *SignalName_, requestKey};
    }

private:
    std::optional<NZoom::NHost::THostName> HostName_;
    std::optional<NZoom::NSignal::TSignalName> SignalName_;
    TStringBuilder RequestKeyBuilder_;
};

} // namespace

TYasmKey TYasmKey::FromSelectors(TStringBuf itype, const NSolomon::TSelectors& selectors) {
    TYasmKeyBuilder builder{itype};
    for (const auto& selector: selectors) {
        builder.Add(selector.Key(), selector.Pattern());
    }
    return builder.Build();
}

TYasmKey TYasmKey::FromLabels(TStringBuf itype, const NMonitoring::TLabels& labels) {
    TYasmKeyBuilder builder{itype};
    for (const auto& label: labels) {
        builder.Add(label.Name(), label.Value());
    }
    return builder.Build();
}

} // namespace NSolomon::NYasm
