#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/yasm/convertion/convertion.h>

#include <util/string/cast.h>

using namespace NSolomon::NYasm;

constexpr TStringBuf LABELS = "{cluster=group_0, project=yasm_yasmtsdb, service=yasm, "
                              "ctype=prod, gencfg=VLA_YASM_PRODUCTION_TSDB, geo=vla, "
                              "group=VLA.025.0, host=/SELF, nanny=production_yasm_tsdb_misc_vla, "
                              "prj=yasm, signal=counter-instance_tmmv, tier=none}";

constexpr TStringBuf ITYPE = "yasmtsdb";

constexpr TStringBuf TAGS = "itype=yasmtsdb;ctype=prod;gencfg=VLA_YASM_PRODUCTION_TSDB;"
                            "geo=vla;nanny=production_yasm_tsdb_misc_vla;prj=yasm;tier=none;group=VLA.025.0";

TEST(ConversionTest, TestSelectors) {
    NSolomon::TSelectors selectors = NSolomon::ParseSelectors(LABELS);
    auto key = TYasmKey::FromSelectors(ITYPE, selectors);
    EXPECT_EQ(key.HostName, NZoom::NHost::THostName{"VLA.025.0"sv});
    EXPECT_EQ(key.SignalName, NZoom::NSignal::TSignalName{"counter-instance_tmmv"sv});
    EXPECT_EQ(key.RequestKey, NZoom::NSubscription::TInternedRequestKey{TAGS});
}

TEST(ConversionTest, TestLabels) {
    NMonitoring::TLabels labels;
    bool success = NMonitoring::TryLoadLabelsFromString(LABELS, labels);
    ASSERT_TRUE(success);
    auto key = TYasmKey::FromLabels(ITYPE, labels);
    EXPECT_EQ(key.HostName, NZoom::NHost::THostName{"VLA.025.0"sv});
    EXPECT_EQ(key.SignalName, NZoom::NSignal::TSignalName{"counter-instance_tmmv"sv});
    EXPECT_EQ(key.RequestKey, NZoom::NSubscription::TInternedRequestKey{TAGS});
}
