#pragma once

#include <util/generic/algorithm.h>
#include <util/generic/strbuf.h>
#include <util/string/ascii.h>

namespace NSolomon::NYasm {

/**
 * Checks if a value (usually passed to the hosts label) is a group or a metagroup
 *
 * Example:
 *     IsGroupOrMetagroup("ASEARCH") -> true
 *     IsGroupOrMetagroup("sas-001.search.yandex.net") -> false
 *     IsGroupOrMetagroup("IVA.005") -> true
 */
inline bool IsGroupOrMetagroup(TStringBuf value) {
    return !AnyOf(value, [](unsigned char c) {
        return IsAsciiLower<unsigned char>(c);
    });
}

} // namespace NSolomon::NYasm

