#include "shard_config.h"

#include <infra/yasm/stockpile_client/settings.h>
#include <library/cpp/resource/resource.h>

using namespace NHistDb::NStockpile;

namespace NSolomon::NYasm {
namespace {
    class TShardConfig: public IShardConfig {
    public:
        TShardConfig(TStringBuf raw)
            : Config_{raw}
        {
        }

        ui64 GetShardCount(TStringBuf itype) const override {
            return Config_.GetShardsCount(itype);
        }

    private:
        TMetabaseConfig Config_;
    };
} // namespace
    IShardConfigPtr CreateShardConfig(TStringBuf raw) {
        return std::make_shared<TShardConfig>(raw);
    }

    IShardConfigPtr CreateDefaultShardConfig() {
        auto conf = NResource::Find("yasm_shards.conf");
        return CreateShardConfig(conf);
    }

    IShardConfigPtr CreateStubConfig() {
        struct TStub: IShardConfig {
            ui64 GetShardCount(TStringBuf) const override {
                return 1;
            }
        };

        return std::make_shared<TStub>();
    }
} // namespace NSolomon::NYasm
