#pragma once

#include <util/generic/ptr.h>

namespace NSolomon::NYasm {
    class IShardConfig {
    public:
        virtual ~IShardConfig() = default;
        virtual ui64 GetShardCount(TStringBuf itype) const = 0;
    };

    using IShardConfigPtr = std::shared_ptr<IShardConfig>;

    IShardConfigPtr CreateShardConfig(TStringBuf raw);
    IShardConfigPtr CreateDefaultShardConfig();
    IShardConfigPtr CreateStubConfig();
} // namespace NSolomon::NYasm
