#include "counters.h"

using namespace NMonitoring;

namespace NSolomon::NDb {
    TMethodCounter::TMethodCounter(TMetricRegistry& registry, TStringBuf daoName, TStringBuf method) {
        TLabel daoLabel{"dao", daoName};
        TLabel methodLabel{"method", method};

        Timings = registry.HistogramRate(
            {daoLabel, methodLabel, {"sensor", "ydb.ops.elapsedTimeMs"}}, ExponentialHistogram(13, 2, 16));
        Inflight = registry.IntGauge({daoLabel, methodLabel, {"sensor", "ydb.ops.inFlight"}});
        Started = registry.Rate({daoLabel, methodLabel, {"sensor", "ydb.ops.started"}});
        CompletedOk = registry.Rate({daoLabel, methodLabel, {"sensor", "ydb.ops.completedOk"}});
        CompletedError = registry.Rate({daoLabel, methodLabel, {"sensor", "ydb.ops.completedError"}});
    }

    TCallScopeCounter::TCallScopeCounter(TMethodCounter counters)
        : Counters_{std::move(counters)}
        , Timer_{FutureTimer(Counters_.Timings)}
    {
        Counters_.Inflight->Inc();
        Counters_.Started->Inc();
    }

    void TCallScopeCounter::RecordError() const {
        Counters_.CompletedError->Inc();
        Completed_ = true;
    }

    TCallScopeCounter::~TCallScopeCounter() {
        if (Counters_.Inflight != nullptr) {
            Counters_.Inflight->Dec();
        }

        if (!Completed_ && Counters_.CompletedOk != nullptr) {
            Counters_.CompletedOk->Inc();
        }
    }

    void TCallScopeCounter::Steal(const TCallScopeCounter& other) {
        Counters_ = std::move(other.Counters_);
        Counters_ = {};
        Timer_ = std::move(other.Timer_);
        Completed_ = other.Completed_;
    }
} // namespace NSolomon::NDb
