#pragma once

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/monlib/metrics/timer.h>

namespace NSolomon::NDb {
    struct TMethodCounter {
        TMethodCounter() = default;
        TMethodCounter(NMonitoring::TMetricRegistry& registry, TStringBuf daoName, TStringBuf method);

        NMonitoring::THistogram* Timings{nullptr};
        NMonitoring::TIntGauge* Inflight{nullptr};
        NMonitoring::TRate* Started{nullptr};
        NMonitoring::TRate* CompletedOk{nullptr};
        NMonitoring::TRate* CompletedError{nullptr};
    };

    struct TCallScopeCounter {
        TCallScopeCounter(TMethodCounter);
        ~TCallScopeCounter();

        TCallScopeCounter(const TCallScopeCounter& other)
            : Counters_{std::move(other.Counters_)}
            , Timer_{std::move(other.Timer_)}
            , Completed_{other.Completed_}
        {
            other.Counters_ = {};
        }

        TCallScopeCounter& operator=(const TCallScopeCounter& other) {
            Steal(other);
            return *this;
        }

        TCallScopeCounter(TCallScopeCounter&& other)
            : Counters_{std::move(other.Counters_)}
            , Timer_{std::move(other.Timer_)}
            , Completed_{other.Completed_}
        {
            other.Counters_ = {};
        }

        TCallScopeCounter& operator=(TCallScopeCounter&& other) {
            Steal(other);
            return *this;
        }

        void RecordError() const;

    private:
        void Steal(const TCallScopeCounter& other);

        mutable TMethodCounter Counters_;
        mutable NMonitoring::TFutureFriendlyTimer<NMonitoring::THistogram> Timer_;
        mutable bool Completed_{false};
    };

} // namespace NSolomon::NDb
