#include <solomon/libs/cpp/ydb/counters.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NDb;
using namespace NMonitoring;

TEST(TCounterTest, InflightSimple) {
    TMetricRegistry registry;
    TString dao{"foo"};
    TString method{"bar"};

    TMethodCounter c{registry, dao, method};
    auto* inflight = c.Inflight;
    {
        TCallScopeCounter scopeCounter{c};
        ASSERT_EQ(inflight->Get(), 1);
    }

    ASSERT_EQ(inflight->Get(), 0);
}

TEST(TCounterTest, InflightCopy) {
    TMetricRegistry registry;
    TString dao{"foo"};
    TString method{"bar"};

    TMethodCounter c{registry, dao, method};
    auto* inflight = c.Inflight;
    {
        TCallScopeCounter scopeCounter{c};
        [=, other{scopeCounter}] {
            ASSERT_EQ(inflight->Get(), 1);
        }();
        ASSERT_EQ(inflight->Get(), 0);
    }

    {
        TCallScopeCounter scopeCounter{c};
        [=, other = scopeCounter] {
            ASSERT_EQ(inflight->Get(), 1);
        }();
        ASSERT_EQ(inflight->Get(), 0);
    }

    {
        TCallScopeCounter scopeCounter{c};
        [=, other{std::move(scopeCounter)}] {
            ASSERT_EQ(inflight->Get(), 1);
        }();
        ASSERT_EQ(inflight->Get(), 0);
    }

    ASSERT_EQ(inflight->Get(), 0);
}
