package abc

import (
	"a.yandex-team.ru/solomon/libs/go/uhttp"
	"context"
	"fmt"
	"time"
)

const (
	baseURL     = "https://abc-back.yandex-team.ru/api/v4"
	shiftFields = "schedule.id," +
		"schedule.name," +
		"person.id," +
		"person.login," +
		"replaces.id," +
		"replaces.person.id," +
		"replaces.person.login"
)

type Client interface {
	Shifts(ctx context.Context, filter *Filter) ([]Shift, error)
}

type clientImpl struct {
	httpClient *uhttp.Client
}

func NewClient(token string) Client {
	return &clientImpl{
		httpClient: uhttp.NewClient(baseURL, "", uhttp.OAuthToken(token), 5*time.Second, false),
	}
}

func (c *clientImpl) Shifts(ctx context.Context, filter *Filter) ([]Shift, error) {
	url := fmt.Sprintf(
		"/duty/shifts/?service=%d&date_from=%s&date_to=%s&fields=%s",
		filter.ServiceID,
		filter.From.Format("2006-01-02"),
		filter.To.Format("2006-01-02"),
		shiftFields)

	req, err := c.httpClient.NewGetRequest(ctx, url)
	if err != nil {
		return nil, err
	}

	var resp struct {
		Shifts []Shift `json:"results"`
	}
	if err = c.httpClient.SendJSONRequest(req, &resp); err != nil {
		return nil, err
	}

	if filter.ScheduleID == 0 {
		return resp.Shifts, nil
	}

	shifts := make([]Shift, 0, len(resp.Shifts))
	for _, shift := range resp.Shifts {
		if shift.Schedule.ID == filter.ScheduleID {
			shifts = append(shifts, shift)
		}
	}
	return shifts, nil
}
