package abc

import "time"

type ServiceID int
type ScheduleID int

const (
	ServiceSolomon ServiceID = 700

	ScheduleSupport ScheduleID = 2896
	ScheduleIM      ScheduleID = 3182
	ScheduleSRE     ScheduleID = 3284
)

type Filter struct {
	ServiceID  ServiceID
	ScheduleID ScheduleID
	From       time.Time
	To         time.Time
}

func FilterToday() *Filter {
	return FilterAtDay(time.Now())
}

func FilterAtDay(date time.Time) *Filter {
	return &Filter{ServiceID: ServiceSolomon, From: date, To: date}
}

func FilterScheduleToday(schedID ScheduleID) *Filter {
	return FilterScheduleAtDay(schedID, time.Now())
}

func FilterScheduleAtDay(schedID ScheduleID, date time.Time) *Filter {
	return &Filter{ServiceID: ServiceSolomon, ScheduleID: schedID, From: date, To: date}
}

func FilterScheduleRange(schedID ScheduleID, from, to time.Time) *Filter {
	return &Filter{ServiceID: ServiceSolomon, ScheduleID: schedID, From: from, To: to}
}
