package abc

import "time"

type Person struct {
	ID    int    `json:"id"`
	Login string `json:"login"`
}

type Schedule struct {
	ID   ScheduleID `json:"id"`
	Name string     `json:"name"`
}

type Replace struct {
	ID     int       `json:"id"`
	Person Person    `json:"person"`
	Start  time.Time `json:"start_datetime"`
	End    time.Time `json:"end_datetime"`
}

type Shift struct {
	Person   Person    `json:"person"`
	Schedule Schedule  `json:"schedule"`
	Replaces []Replace `json:"replaces"`
	Start    time.Time `json:"start_datetime"`
	End      time.Time `json:"end_datetime"`
}

func (r *Replace) isActive(at time.Time) bool {
	return !at.Before(r.Start) && at.Before(r.End)
}

func (s *Shift) isActive(at time.Time) bool {
	return !at.Before(s.Start) && at.Before(s.End)
}

func (s *Shift) Duty(at time.Time) *Person {
	for _, r := range s.Replaces {
		if r.isActive(at) {
			return &r.Person
		}
	}
	if s.isActive(at) {
		return &s.Person
	}
	return nil
}
