package brexp

import (
	"regexp"
	"strconv"
	"strings"
)

// ==========================================================================================

var reBrDots = regexp.MustCompile(`^{([+-]?[0-9]+|[a-zA-Z])\.\.([+-]?[0-9]+|[a-zA-Z])(?:\.\.[+-]?([0-9]+))?}$`)

func fmtForRange(n, zeroes int) string {
	if zeroes < 0 {
		return string(rune(n))
	}
	s := strconv.FormatInt(int64(n), 10)
	if zeroes == 0 || len(s) >= zeroes {
		return s
	}
	b := make([]byte, zeroes)
	nFill := zeroes - len(s)
	nLen := len(b)
	for i, j := 0, 0; j < nLen; j++ {
		if j < nFill {
			b[j] = '0'
		} else {
			b[j] = s[i]
			i++
		}
	}
	if n < 0 {
		b[0], b[nFill] = '-', '0'
	}
	return string(b)
}

func zeroForRange(s *string) bool {
	return (len(*s) > 1 && (*s)[0] == '0') || (len(*s) > 2 && (*s)[0] <= '-' && (*s)[1] == '0')
}

func openRange(str string) []string {
	m := reBrDots.FindAllStringSubmatch(str, -1)
	if len(m) == 0 {
		return nil
	}
	beginStr, endStr, stepStr := m[0][1], m[0][2], m[0][3]
	begin, end, step, zeroes := 0, 0, 1, 0

	if beginStr[0] > 'A' && endStr[0] > 'A' {
		begin, end = int(beginStr[0]), int(endStr[0])
		zeroes = -1
	} else if beginStr[0] > '9' || endStr[0] > '9' {
		return nil
	} else if zeroForRange(&beginStr) || zeroForRange(&endStr) {
		if len(beginStr) > len(endStr) {
			zeroes = len(beginStr)
		} else {
			zeroes = len(endStr)
		}
	}

	if begin == 0 {
		begin, _ = strconv.Atoi(beginStr)
		end, _ = strconv.Atoi(endStr)
	}
	if len(stepStr) != 0 {
		step, _ = strconv.Atoi(stepStr)
		if step == 0 {
			step = 1
		}
	}

	if begin <= end {
		res := make([]string, 0, (end-begin)/step+1)
		for i := begin; i <= end; i += step {
			res = append(res, fmtForRange(i, zeroes))
		}
		return res
	} else {
		res := make([]string, 0, (begin-end)/step+1)
		for i := begin; i >= end; i -= step {
			res = append(res, fmtForRange(i, zeroes))
		}
		return res
	}
}

func decMult(a, b interface{}) []string {
	if as, ok := a.(string); ok {
		if bs, ok := b.(string); ok {
			return []string{as + bs}
		} else {
			bs := b.([]string)
			n := len(bs)
			if n == 0 {
				bs = append(bs, as)
			} else if len(as) > 0 {
				for i := 0; i < n; i++ {
					bs[i] = as + bs[i]
				}
			}
			return bs
		}
	} else {
		as := a.([]string)
		if bs, ok := b.(string); ok {
			n := len(as)
			if n == 0 {
				as = append(as, bs)
			} else if len(bs) > 0 {
				for i := 0; i < n; i++ {
					as[i] = as[i] + bs
				}
			}
			return as
		} else {
			bs := b.([]string)
			n, m := len(as), len(bs)
			if n == 0 {
				return bs
			}
			if m == 0 {
				return as
			}
			if n == 1 {
				return decMult(as[0], bs)
			}
			if m == 1 {
				return decMult(as, bs[0])
			}
			abs := make([]string, n*m)
			for i := 0; i < n; i++ {
				for j := 0; j < m; j++ {
					abs[i*m+j] = as[i] + bs[j]
				}
			}
			return abs
		}
	}
}

func openTokens(str string) []string {
	if res := openRange(str); res != nil {
		return res
	}
	res := make([]string, 0, len(str)/2)
	acc := make([]string, 0, len(str)/2)
	hasTokens := false
	depth, b := 0, 1
	n := len(str)
	for i := 0; i < n; i++ {
		c := str[i]
		if c == ',' {
			if depth == 1 {
				res = append(res, decMult(acc, str[b:i])...)
				acc = acc[:0]
				b = i + 1
				hasTokens = true
			}
		} else if c == '{' {
			if depth == 1 {
				acc = decMult(acc, str[b:i])
				b = i
			}
			depth++
		} else if c == '}' {
			depth--
			if depth == 1 {
				acc = decMult(acc, openTokens(str[b:i+1]))
				b = i + 1
			} else if depth == 0 {
				res = append(res, decMult(acc, str[b:i])...)
			}
		}
	}
	if !hasTokens {
		n := len(res)
		for i := 0; i < n; i++ {
			res[i] = "{" + res[i] + "}"
		}
	}
	return res
}

func Expand(str string) []string {
	openBraces := make([]int, 0, len(str)/2)
	fullTokens := make([]int, 0, len(str)/2)
	n := len(str)
	for i := 0; i < n; i++ {
		c := str[i]
		if c == '{' {
			openBraces = append(openBraces, i)
		} else if c == '}' {
			m := len(openBraces)
			if m > 0 {
				braceIdx := openBraces[m-1]
				for j := len(fullTokens) - 2; j >= 0 && fullTokens[j] > braceIdx; j -= 2 {
					fullTokens = fullTokens[:j]
				}
				fullTokens = append(fullTokens, braceIdx, i)
				openBraces = openBraces[:m-1]
			}
		}
	}
	n = len(fullTokens)
	if n == 0 {
		return []string{str}
	}
	res := make([]string, 0)
	for i, p := 0, 0; i < n; i += 2 {
		res = decMult(res, str[p:fullTokens[i]])
		p = fullTokens[i+1] + 1
		res = decMult(res, openTokens(str[fullTokens[i]:p]))
	}
	res = decMult(res, str[fullTokens[n-1]+1:])
	return res
}

func ExpandWithSpaces(str string) []string {
	res := []string{}
	for _, s := range strings.Split(str, " ") {
		res = append(res, Expand(s)...)
	}
	return res
}
