package color

const (
	normal = "\033[0;"
	bold   = "\033[1;"

	black  = "30m"
	red    = "31m"
	green  = "32m"
	yellow = "33m"
	blue   = "34m"
	purple = "35m"
	cyan   = "36m"
	white  = "37m"

	clear = "\033[0m"
)

// Black color may be invisible on dark-themed terminals
func Black(msg string) string {
	return normal + black + msg + clear
}

func Red(msg string) string {
	return normal + red + msg + clear
}

func Green(msg string) string {
	return normal + green + msg + clear
}

func Yellow(msg string) string {
	return normal + yellow + msg + clear
}

func Blue(msg string) string {
	return normal + blue + msg + clear
}

func Purple(msg string) string {
	return normal + purple + msg + clear
}

func Cyan(msg string) string {
	return normal + cyan + msg + clear
}

// White color may be invisible on light-themed terminals
func White(msg string) string {
	return normal + white + msg + clear
}

// BoldBlack color may be invisible on dark-themed terminals
func BoldBlack(msg string) string {
	return bold + black + msg + clear
}

func BoldRed(msg string) string {
	return bold + red + msg + clear
}

func BoldGreen(msg string) string {
	return bold + green + msg + clear
}

func BoldYellow(msg string) string {
	return bold + yellow + msg + clear
}

func BoldBlue(msg string) string {
	return bold + blue + msg + clear
}

func BoldPurple(msg string) string {
	return bold + purple + msg + clear
}

func BoldCyan(msg string) string {
	return bold + cyan + msg + clear
}

// BoldWhite color may be invisible on light-themed terminals
func BoldWhite(msg string) string {
	return bold + white + msg + clear
}
