package conductor

import (
	"a.yandex-team.ru/solomon/libs/go/uhttp"
	"bytes"
	"context"
	"fmt"
	"strings"
	"time"
)

const (
	baseURL     = "https://c.yandex-team.ru/api"
	httpTimeout = 5 * time.Second
)

type Client struct {
	httpClient *uhttp.Client
}

func NewClient() *Client {
	return &Client{httpClient: uhttp.NewClient(baseURL, "", nil, httpTimeout, true)}
}

func NewClientWithTimeout(timeout time.Duration) *Client {
	return &Client{httpClient: uhttp.NewClient(baseURL, "", nil, timeout, true)}
}

func (c *Client) getStrings(ctx context.Context, url string) ([]string, error) {
	req, err := c.httpClient.NewGetRequest(ctx, url)
	if err != nil {
		return nil, err
	}

	resp, err := c.httpClient.SendRequest(req)
	if err != nil {
		return nil, err
	}

	resp = bytes.TrimSpace(resp)
	return strings.Split(string(resp), "\n"), nil
}

func (c *Client) GroupToHosts(ctx context.Context, group string) ([]string, error) {
	return c.getStrings(ctx, fmt.Sprintf("/groups2hosts/%s", group))
}

func (c *Client) GroupToProjects(ctx context.Context, group string) ([]string, error) {
	return c.getStrings(ctx, fmt.Sprintf("/groups2projects/%s", group))
}

func (c *Client) TagToHosts(ctx context.Context, tag string) ([]string, error) {
	return c.getStrings(ctx, fmt.Sprintf("/tag2hosts/%s", tag))
}

func (c *Client) HostToGroups(ctx context.Context, host string) ([]string, error) {
	return c.getStrings(ctx, fmt.Sprintf("/hosts2groups/%s", host))
}
