package grpc

import (
	"a.yandex-team.ru/library/go/certifi"
	"context"
	"crypto/x509"
	"fmt"
	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials"
	"strings"
)

var caCertPool *x509.CertPool

func init() {
	var err error
	caCertPool, err = certifi.NewCertPoolSystem()
	if err != nil {
		panic(fmt.Sprintf("failed to create cert pool: %v", err))
	}
}

func NewConnection(ctx context.Context, addr string, opts ...grpc.DialOption) (*grpc.ClientConn, error) {
	creds := credentials.NewClientTLSFromCert(caCertPool, removePort(addr))
	opts = append(
		[]grpc.DialOption{
			grpc.WithTransportCredentials(creds),
		},
		opts...)

	return grpc.DialContext(ctx, addr, opts...)
}

func removePort(addr string) string {
	if idx := strings.LastIndexByte(addr, ':'); idx != -1 {
		return addr[:idx]
	}
	return addr
}
