package grpc

import (
	"context"
	"google.golang.org/grpc"
)

type iamTokenCredentials struct {
	token string
}

func (c iamTokenCredentials) GetRequestMetadata(_ context.Context, _ ...string) (map[string]string, error) {
	return map[string]string{"Authorization": "Bearer " + c.token}, nil
}

func (c iamTokenCredentials) RequireTransportSecurity() bool {
	return true
}

func NewIamTokenCredentials(token string) grpc.DialOption {
	return grpc.WithPerRPCCredentials(&iamTokenCredentials{token})
}
