package hosts

import "net"

type Address struct {
	Name string
	IP   net.IP
}

// MoveToTheEnd moves item with index idx to the end of the slice
func MoveToTheEnd(addresses []Address, idx int) {
	lastIdx := len(addresses) - 1
	addresses[lastIdx], addresses[idx] = addresses[idx], addresses[lastIdx]
}

// FindByName returns index of the address with given name
func FindByName(addresses []Address, name string) int {
	for i, addr := range addresses {
		if addr.Name == name {
			return i
		}
	}
	return -1
}
