package cloud

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net"
	"net/http"
	"time"
)

const (
	MetaDataAddr    = "127.0.0.1:6770"
	CredentialsPath = "/latest/meta-data/iam/security-credentials/default"
)

type MetaDataService struct {
}

func (ms MetaDataService) IsAvailable() bool {
	conn, err := net.DialTimeout("tcp", MetaDataAddr, time.Second)
	if conn != nil {
		_ = conn.Close()
	}
	return err == nil
}

func (ms MetaDataService) GetIamToken() (string, error) {
	client := http.Client{Timeout: time.Second}

	resp, err := client.Get("http://" + MetaDataAddr + CredentialsPath)
	if err != nil {
		return "", fmt.Errorf("http get to local meta-data service failed, %v", err)
	}
	defer resp.Body.Close()

	respBody, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return "", fmt.Errorf("cannot read response body, %v", err)
	}

	if resp.StatusCode != 200 {
		return "", fmt.Errorf("non 200 response from local meta-data service, %d %s", resp.StatusCode, string(respBody))
	}

	var respData struct {
		Token string
	}

	if err = json.Unmarshal(respBody, &respData); err != nil {
		return "", fmt.Errorf("cannot parse JSON from local meta-data service response, %v", err)
	}

	return respData.Token, nil
}
