package selector

func MatchGlob(glob string, value string) bool {
	return matchRecursive(glob, value, 0, 0)
}

func matchRecursive(glob string, value string, globStart int, valueStart int) bool {
	gLength := len(glob)
	vLength := len(value)
	gIndex := globStart
	vIndex := valueStart

	for gIndex < gLength && vIndex < vLength {
		r := glob[gIndex]
		if r == '?' || r == value[vIndex] {
			gIndex++
			vIndex++
		} else if r == '*' {
			gIndex++
			if gIndex < gLength {
				for ; vIndex < vLength; vIndex++ {
					if matchRecursive(glob, value, gIndex, vIndex) {
						return true
					}
				}
				return false
			}
			return true
		} else {
			return false
		}
	}

	for gIndex < gLength && glob[gIndex] == '*' {
		gIndex++
	}
	return gIndex == gLength && vIndex == vLength
}
