package staff

import (
	"a.yandex-team.ru/solomon/libs/go/uhttp"
	"context"
	"time"
)

const (
	baseURL      = "https://staff-api.yandex-team.ru/v3"
	personFields = "phones,accounts,name,work_email,work_phone"
)

type Client interface {
	Person(ctx context.Context, login string) (*Person, error)
}

type clientImpl struct {
	httpClient *uhttp.Client
}

func NewClient(token string) Client {
	return &clientImpl{
		httpClient: uhttp.NewClient(baseURL, "", uhttp.OAuthToken(token), 5*time.Second, false),
	}
}

func (c *clientImpl) Person(ctx context.Context, login string) (*Person, error) {
	req, err := c.httpClient.NewGetRequest(ctx, "/persons?_one=1&login="+login+"&_fields="+personFields)
	if err != nil {
		return nil, err
	}

	var person Person
	if err = c.httpClient.SendJSONRequest(req, &person); err != nil {
		return nil, err
	}

	return &person, nil
}
