package staff

type LocalizedText struct {
	Ru string `json:"ru"`
	En string `json:"en"`
}

type Name struct {
	First LocalizedText `json:"first"`
	Last  LocalizedText `json:"last"`
}

type Account struct {
	ID      int    `json:"id"`
	Type    string `json:"type"`
	Value   string `json:"value"`
	Private bool   `json:"private"`
}

type Phone struct {
	ID     int    `json:"id"`
	Type   string `json:"type"`
	Number string `json:"number"`
	IsMain bool   `json:"is_main"`
}

type Person struct {
	WorkEmail string    `json:"work_email"`
	WorkPhone int       `json:"work_phone"`
	Phones    []Phone   `json:"phones"`
	Accounts  []Account `json:"accounts"`
	Name      Name      `json:"name"`
}

func (p *Person) FullNameRu() string {
	return p.Name.First.Ru + " " + p.Name.Last.Ru
}

func (p *Person) FullNameEn() string {
	return p.Name.First.En + " " + p.Name.Last.En
}

func (p *Person) MainPhone() string {
	for _, phone := range p.Phones {
		if phone.IsMain {
			return phone.Number
		}
	}
	return ""
}

func (p *Person) Telegram() string {
	for _, a := range p.Accounts {
		if !a.Private && a.Type == "telegram" {
			return a.Value
		}
	}
	return ""
}
