package tracker

import (
	"strconv"
	"strings"
)

var (
	StatusCommited        = "commited"
	StatusInProgress      = "inProgress"
	StatusNew             = "new"
	StatusOpen            = "open"
	StatusReadyForRelease = "readyForRelease"
	StatusClosed          = "closed"
)

type Filter struct {
	Queue      *Queue
	Components []int
	Statuses   []string
}

func (f *Filter) String() string {
	sb := strings.Builder{}
	if f.Queue != nil {
		sb.WriteString("filter=queue:")
		sb.WriteString(f.Queue.Key)
		sb.WriteByte('&')
	}
	if len(f.Components) != 0 {
		sb.WriteString("filter=components:")
		for i, c := range f.Components {
			if i > 0 {
				sb.WriteByte(',')
			}
			sb.WriteString(strconv.Itoa(c))
		}
		sb.WriteByte('&')
	}
	if len(f.Statuses) != 0 {
		sb.WriteString("filter=status:")
		for i, s := range f.Statuses {
			if i > 0 {
				sb.WriteByte(',')
			}
			sb.WriteString(s)
		}
		sb.WriteByte('&')
	}
	return strings.TrimSuffix(sb.String(), "&")
}
