package uhttp

import (
	"math/rand"
	"time"
)

const (
	minRetryDelay = 1 * time.Second
	maxRetryDelay = 10 * time.Second
)

// Return linearly increasing duration with half jitter
func nextDelay(attempt, maxAttempts int) time.Duration {
	interval := float64(maxRetryDelay-minRetryDelay) / float64(maxAttempts)
	delay := float64(attempt) * interval

	halfJitter := rand.Float64() * (delay / 2)
	return minRetryDelay + time.Duration(delay/2+halfJitter)
}
