package ussh

import (
	"fmt"
	"golang.org/x/crypto/ssh/agent"
	"net"
	"os"
)

func fileExists(filename string) bool {
	stat, err := os.Stat(filename)
	if err != nil {
		return !os.IsNotExist(err)
	}
	return !stat.IsDir()
}

func newSSHAgent() agent.ExtendedAgent {
	authSock := os.Getenv("SSH_AUTH_SOCK")
	if len(authSock) == 0 || !fileExists(authSock) {
		return nil
	}
	sshAgent, err := net.Dial("unix", authSock)
	if err != nil {
		fmt.Fprintf(os.Stderr, "cannot connect to SSH agent by %s socket: %v", authSock, err)
		return nil
	}
	return agent.NewClient(sshAgent)
}
