package ussh

import "a.yandex-team.ru/solomon/libs/go/hosts"

type Client interface {
	Connect(address *hosts.Address) (Connection, error)
	Close()
}

type Connection interface {
	Run(cmd string) ([]byte, error)
	Close()
}

func NewClient(useBastion bool) Client {
	if useBastion {
		return NewPSSHClient(nil)
	}

	return NewSSHClient(false)
}
