package ussh

import (
	"a.yandex-team.ru/solomon/libs/go/hosts"
	"fmt"
	"golang.org/x/crypto/ssh"
	"golang.org/x/crypto/ssh/agent"
	"os"
)

type SSHConnection struct {
	address         *hosts.Address
	sshClient       *ssh.Client
	sshAgentPresent bool
}

func (c *SSHConnection) Run(cmd string) ([]byte, error) {
	sshSession, err := c.sshClient.NewSession()
	if err != nil {
		return nil, fmt.Errorf("cannot establish ssh session with %s: %v", c.address.Name, err)
	}
	defer func() { _ = sshSession.Close() }()

	if c.sshAgentPresent {
		err = agent.RequestAgentForwarding(sshSession)
		if err != nil {
			return nil, fmt.Errorf("cannot enable ssh aggent forwarding for %s: %w", c.address.Name, err)
		}
	}
	return sshSession.CombinedOutput(cmd)
}

func (c *SSHConnection) Close() {
	err := c.sshClient.Close()
	if err != nil {
		fmt.Fprintf(os.Stderr, "cannot close ssh connection to %s: %v", c.address.Name, err)
	}
}
