package utils

import (
	"fmt"
	"github.com/mattn/go-isatty"
	"os"
	"time"
)

func Sleep(d time.Duration) {
	seconds := int(d.Seconds())
	if seconds == 0 {
		return
	}

	if seconds <= 3 || !isatty.IsTerminal(os.Stderr.Fd()) {
		time.Sleep(time.Duration(seconds) * time.Second)
	} else {
		for i := 0; i < seconds; i++ {
			fmt.Fprintf(os.Stderr, "\033[1000D    left %ds ...", seconds-i)
			time.Sleep(time.Second)
		}
		fmt.Fprintf(os.Stderr, "\033[100D")
	}
}

func SleepWithoutPrint(d time.Duration) {
	seconds := int(d.Seconds())
	if seconds == 0 {
		return
	}

	if seconds <= 3 || !isatty.IsTerminal(os.Stderr.Fd()) {
		time.Sleep(time.Duration(seconds) * time.Second)
	} else {
		for i := 0; i < seconds; i++ {
			time.Sleep(time.Second)
		}
	}
}
