package ru.yandex.solomon.acl.db;

import javax.annotation.Nullable;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.acl.db.ydb.YdbGroupMemberDao;
import ru.yandex.solomon.acl.db.ydb.YdbProjectAclEntryDao;
import ru.yandex.solomon.acl.db.ydb.YdbServiceProviderAclEntryDao;
import ru.yandex.solomon.acl.db.ydb.YdbSystemAclEntryDao;
import ru.yandex.solomon.core.db.YdbClientsContext;
import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;


/**
 * @author Alexey Trushkin
 */
@Configuration
@Import({
        YdbClientsContext.class,
})
public class AclDaoContext {

    private static final String ACL_DIR = "Acl";
    private static final String VERSION = "V1";

    private final SchemeClient schemeClient;
    private final TableClient tableClient;
    @Nullable
    private final MetricRegistry metricRegistry;
    private final String ydbPath;

    @Autowired
    public AclDaoContext(
            TableClient tableClient,
            SchemeClient schemeClient,
            @Qualifier("configKikimrRootPath") String rootSchema,
            @Nullable MetricRegistry metricRegistry) {
        this.tableClient = tableClient;
        this.schemeClient = schemeClient;
        this.metricRegistry = metricRegistry;
        this.ydbPath = rootSchema + "/" + ACL_DIR + "/" + VERSION + "/";
    }

    @Bean
    public ProjectAclEntryDao projectAclEntryDao() {
        var dao = new YdbProjectAclEntryDao(ydbPath, tableClient, schemeClient);
        return measure(dao, ProjectAclEntryDao.class);
    }

    @Bean
    public SystemAclEntryDao systemAclEntryDao() {
        var dao = new YdbSystemAclEntryDao(ydbPath, tableClient, schemeClient);
        return measure(dao, SystemAclEntryDao.class);
    }

    @Bean
    public GroupMemberDao groupMemberDao() {
        var dao = new YdbGroupMemberDao(ydbPath, tableClient, schemeClient);
        return measure(dao, GroupMemberDao.class);
    }

    @Bean
    public ServiceProviderAclEntryDao serviceProviderAclEntryDao() {
        var dao = new YdbServiceProviderAclEntryDao(ydbPath, tableClient, schemeClient);
        return measure(dao, ServiceProviderAclEntryDao.class);
    }

    private <TDao> TDao measure(TDao dao, Class<TDao> daoClass) {
        return metricRegistry == null ? dao : DaoMetricsProxy.of(dao, daoClass, metricRegistry);
    }
}
