package ru.yandex.solomon.acl.db;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.acl.db.model.GroupMember;
import ru.yandex.solomon.core.db.SchemaAwareDao;

/**
 * @author Alexey Trushkin
 */
public interface GroupMemberDao extends SchemaAwareDao {

    CompletableFuture<Void> create(Collection<GroupMember> groupMembers);

    CompletableFuture<Void> delete(Collection<GroupMember> groupMembers);

    CompletableFuture<Void> deleteByGroupId(String groupId);

    CompletableFuture<List<GroupMember>> find(String groupId);

    CompletableFuture<List<GroupMember>> getAll();

    CompletableFuture<Boolean> exist(String groupId);
}
