package ru.yandex.solomon.acl.db;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.acl.db.model.AclUidType;
import ru.yandex.solomon.acl.db.model.ProjectAclEntry;
import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Alexey Trushkin
 */
public interface ProjectAclEntryDao extends SchemaAwareDao {

    CompletableFuture<Boolean> create(ProjectAclEntry projectAclEntry);

    CompletableFuture<Void> update(ProjectAclEntry projectAclEntry);

    CompletableFuture<Boolean> delete(ProjectAclEntry projectAclEntry);

    CompletableFuture<Optional<ProjectAclEntry>> find(String projectId, String uid, AclUidType type);

    CompletableFuture<List<ProjectAclEntry>> getAll();

    CompletableFuture<TokenBasePage<ProjectAclEntry>> list(String projectId, int pageSize, String pageToken);
}
