package ru.yandex.solomon.acl.db;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.acl.db.model.AclUidType;
import ru.yandex.solomon.acl.db.model.ServiceProviderAclEntry;
import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Alexey Trushkin
 */
public interface ServiceProviderAclEntryDao extends SchemaAwareDao {

    CompletableFuture<Boolean> create(ServiceProviderAclEntry entry);

    CompletableFuture<Void> update(ServiceProviderAclEntry entry);

    CompletableFuture<Boolean> delete(ServiceProviderAclEntry entry);

    CompletableFuture<Optional<ServiceProviderAclEntry>> find(String serviceProviderId, String uid, AclUidType type);

    CompletableFuture<List<ServiceProviderAclEntry>> getAll();

    CompletableFuture<TokenBasePage<ServiceProviderAclEntry>> list(String serviceProviderId, int pageSize, String pageToken);
}
