package ru.yandex.solomon.acl.db;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.acl.db.model.AclUidType;
import ru.yandex.solomon.acl.db.model.SystemAclEntry;
import ru.yandex.solomon.core.db.SchemaAwareDao;

/**
 * @author Alexey Trushkin
 */
public interface SystemAclEntryDao extends SchemaAwareDao {

    CompletableFuture<Boolean> create(SystemAclEntry systemAclEntry);

    CompletableFuture<List<SystemAclEntry>> getAll();

    CompletableFuture<Void> update(SystemAclEntry systemAclEntry);

    CompletableFuture<Boolean> delete(SystemAclEntry systemAclEntry);

    CompletableFuture<Optional<SystemAclEntry>> find(String uid, AclUidType type);
}
