package ru.yandex.solomon.acl.db.model;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class ProjectAclEntry extends DefaultObject {

    private final String projectId;
    private final String uid;
    private final AclUidType type;
    private Set<String> roles;
    private final int version;

    public ProjectAclEntry(String projectId, String uid, AclUidType type, Set<String> roles, int version) {
        this.projectId = projectId;
        this.uid = uid;
        this.type = type;
        this.roles = roles;
        this.version = version;
    }

    public String getProjectId() {
        return projectId;
    }

    public String getUid() {
        return uid;
    }

    public AclUidType getType() {
        return type;
    }

    public Set<String> getRoles() {
        return roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public static Id compositeId(String projectId, String uid, AclUidType type) {
        return new Id(projectId, uid, type);
    }

    public Id getCompositeId() {
        return compositeId(projectId, uid, type);
    }

    public int getVersion() {
        return version;
    }

    public static ProjectAclEntry copy(ProjectAclEntry copyFrom) {
        return new ProjectAclEntry(
                copyFrom.projectId,
                copyFrom.uid,
                copyFrom.type,
                new HashSet<>(copyFrom.roles),
                copyFrom.version);
    }

    public static record Id(String projectId, String uid, AclUidType type) implements Comparable<Id> {

        @Override
        public int compareTo(Id o) {
            int compare = String.CASE_INSENSITIVE_ORDER.compare(projectId, o.projectId);
            if (compare != 0) {
                return compare;
            }
            compare = String.CASE_INSENSITIVE_ORDER.compare(uid, o.uid);
            if (compare != 0) {
                return compare;
            }

            return String.CASE_INSENSITIVE_ORDER.compare(type.name(), o.type.name());
        }
    }
}
